﻿#Update $RegistryPath Value for your Environment. 
$RegistryPath = "HKLM:\SOFTWARE\WaaS"
$LogFileLocation = "C:\Windows\ccm\Logs"
$LogFileNamePostAction = "WaaS_PostActions.log"
$LogFileNameOSUninstall = "WaaS_OSUninstall.log"
$LogFile = "$LogFileLocation\$LogFileNameOSUninstall"
$OSUninstallBuild = Get-ItemPropertyValue -Path "$RegistryPath" -Name OSUninstall
$RegistryPathFull = "$RegistryPath\$OSUninstallBuild"
$WaaSStage = Get-ItemPropertyValue "$RegistryPathFull" 'WaaS_Stage' -ErrorAction SilentlyContinue
$legalnoticecaption = "WARNING"
$legalnoticetext = "WARNING. You have accessed a private computer system. Unauthorized access, use, connection, or entry is not permitted and constitutes a crime punishable by law. We reserve the right to fully pursue criminal and civil legal penalties. All individuals using this computer system with or without proper authority are subject to having all their activities monitored and recorded. Anyone using this system implicitly consents to this monitoring. Any evidence of suspected criminal activity revealed by such monitoring may be provided to law enforcement officials."

# Schedule Task Names
$OSUninstallDefaultSTN = "WaaS_SetLegalNoticeText-OSUninstallDefault"

#region: CMTraceLog Function formats logging in CMTrace style
        function CMTraceLog {
         [CmdletBinding()]
    Param (
		    [Parameter(Mandatory=$false)]
		    $Message,
 
		    [Parameter(Mandatory=$false)]
		    $ErrorMessage,
 
		    [Parameter(Mandatory=$false)]
		    $Component = $env:computername,
 
		    [Parameter(Mandatory=$false)]
		    [int]$Type,
		
		    [Parameter(Mandatory=$true)]
		    $LogFile
	    )
    <#
    Type: 1 = Normal, 2 = Warning (yellow), 3 = Error (red)
    #>
	    $Time = Get-Date -Format "HH:mm:ss.ffffff"
	    $Date = Get-Date -Format "MM-dd-yyyy"
 
	    if ($ErrorMessage -ne $null) {$Type = 3}
	    if ($Component -eq $null) {$Component = " "}
	    if ($Type -eq $null) {$Type = 1}
 
	    $LogMessage = "<![LOG[$Message $ErrorMessage" + "]LOG]!><time=`"$Time`" date=`"$Date`" component=`"$Component`" context=`"`" type=`"$Type`" thread=`"`" file=`"`">"
	    $LogMessage | Out-File -Append -Encoding UTF8 -FilePath $LogFile
    }

if ($WaaSStage -eq "OSUninstallStarted" -or $WaaSStage -eq "OSUninstallComplete") #OSUninstall is set using a OSUninstall TS post Upgrade, to allow being reverted, so this will never run if this key isn't set by the OSUninstall TS
    {
    $LegalText_DefaultIsEnabled = Get-ItemPropertyValue "$RegistryPathFull" 'LegalText_DefaultIsEnabled' -ErrorAction SilentlyContinue
    if ($LegalText_DefaultIsEnabled -eq "TRUE"){
        $LegalText_DefaultCaption = Get-ItemPropertyValue "$RegistryPathFull" 'LegalText_DefaultCaption' -ErrorAction SilentlyContinue
        $LegalText_DefaultText = Get-ItemPropertyValue "$RegistryPathFull" 'LegalText_DefaultText' -ErrorAction SilentlyContinue
    }

    
    CMTraceLog -Message  "---Starting LegalNotice-Default Script---" -Type 1 -LogFile $LogFile -Component LegalText-Default
    $CurrentLegalCaption = Get-ItemPropertyValue 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' 'legalnoticecaption' -ErrorAction SilentlyContinue
    CMTraceLog -Message  "LegalCaption Data Currently: $CurrentLegalCaption" -Type 1 -LogFile $LogFile -Component LegalText-Default
    if ($LegalText_DefaultIsEnabled -eq "TRUE"){
        if (($LegalText_DefaultCaption -ne $null) -or ($LegalText_DefaultCaption -ne "")){
            Set-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticecaption -Value $LegalText_DefaultCaption
        }
        else{
            Set-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticecaption -Value $legalnoticecaption
        }
        if (($LegalText_DefaultText -ne $null) -or ($LegalText_DefaultText -ne "")){
            Set-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticetext -Value $LegalText_DefaultText
        }
        else{
            Set-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticetext -Value $legalnoticetext
        }
    }
    else {
        Remove-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticecaption -Force -ErrorAction SilentlyContinue
        Remove-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticetext -Force -ErrorAction SilentlyContinue
    }
    CMTraceLog -Message  "Updated Values: legalnoticecaption & legalnoticetext" -Type 1 -LogFile $LogFile -Component LegalText-Default
    $CurrentLegalCaption = Get-ItemPropertyValue 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' 'legalnoticecaption' -ErrorAction SilentlyContinue
    CMTraceLog -Message  "LegalCaption Data Currently: $CurrentLegalCaption" -Type 1 -LogFile $LogFile -Component LegalText-Default
    Unregister-ScheduledTask -TaskName $OSUninstallDefaultSTN -Confirm:$false
    CMTraceLog -Message  "Removed Scheduled Task $OSUninstallDefaultSTN" -Type 1 -LogFile $LogFile -Component LegalText-Default
    CMTraceLog -Message  "---Exiting LegalNotice-Default Script---" -Type 1 -LogFile $LogFile -Component LegalText-Default
    }